let ProfitPerHourHistory = [];
let IndicatorHistory = {};
let Game = {};
let wasd = {up: false, down: false, left: false, right: false};
let wasdListener;
let ShiftPressed = false;
let Language = {};
let EnglishLanguage = {};

(function () {
    let module = angular.module('game', [
        'menu', 'office', 'inbox', 'employees',
        'ui', 'finance', 'products', 'contractReport',
        'workstation', 'clients', 'ngAnimate',
        'contracts', 'purchase', 'ui.bootstrap',
        'company', 'tierReport', 'gameover', 'inventory',
        'message', 'ngDropdowns', 'tableSort', 'rzModule']);

    // Disable Angular security
    module.config(function ($sceProvider, $compileProvider) {
        $sceProvider.enabled(false);
        module.compileProvider = $compileProvider;
    });

    module.run(function ($templateCache, $animate) {
        $templateCache.put('ngDropdowns/templates/dropdownSelectItem.html', [
            '<li ng-class="{divider: (dropdownSelectItem.divider && !dropdownSelectItem[dropdownItemLabel]), \'divider-label\': (dropdownSelectItem.divider && dropdownSelectItem[dropdownItemLabel])}">',
            '<a href="" class="dropdown-item"',
            ' ng-if="!dropdownSelectItem.divider"',
            ' ng-href="{{dropdownSelectItem.href}}"',
            ' ng-click="selectItem()">',
            '<span ng-bind-html="dropdownSelectItem[dropdownItemLabel]"></span>',
            '</a>',
            '<span ng-if="dropdownSelectItem.divider">',
            'JONAS {{dropdownSelectItem[dropdownItemLabel]}}',
            '</span>',
            '</li>'
        ].join(''));

        $templateCache.put('ngDropdowns/templates/dropdownSelect.html', [
            '<div ng-class="{\'disabled\': dropdownDisabled}" class="wrap-dd-select" tabindex="0">',
            '<span class="selected" ng-bind-html="dropdownModel[labelField]"></span>',
            '<ul class="dropdown">',
            '<li ng-repeat="item in dropdownSelect"',
            ' class="dropdown-item"',
            ' dropdown-select-item="item"',
            ' dropdown-item-label="labelField">',
            '</li>',
            '</ul>',
            '</div>'
        ].join(''));
    });

    module.directive('closeAllUi', function () {
        return {
            restrict: 'A',
            link: function (scope, ele, attr) {
                ele.on('click', function () {
                    scope.$root.closeAllUi();
                    scope.$root.$digest();
                    PlaySound(Sounds.click);
                });
            }
        }
    });

    module.directive('localize', function () {
        return {
            restrict: 'A',
            link: function (scope, ele, attr) {
            },
            controller: function ($scope, $attrs, $element, $parse) {
                Object.keys($attrs).filter(x => x.startsWith('localizeData')).forEach(attributeName => {
                    $attrs.$observe(attributeName, () => loadString());
                });

                $attrs.$observe('localize', () => loadString());

                let loadString = (initial) => {
                    let key = $attrs.localize;
                    if (key == '') return;
                    let result = null;

                    if (key != null) {
                        if (key.startsWith('{{')) {
                            key = $parse($attrs[key])($scope);
                            if (key == null) return;
                        }
                        result = Helpers.GetLocalized(key);
                        if (!initial) {
                            Object.keys($attrs).filter(x => x.startsWith('localizeData') && !x.endsWith("Format")).forEach(replaceKey => {
                                let safeKey = _.deburr($attrs[replaceKey]);
                                let value = $parse(safeKey)($scope) || $attrs[replaceKey];
                                if ($attrs[replaceKey + "Format"] != null) {
                                    switch ($attrs[replaceKey + "Format"].toLowerCase()) {
                                        case "currency": {
                                            value = numeral(value).format(Configuration.CURRENCY_FORMAT);
                                            break;
                                        }
                                        case "floor":
                                            value = Math.floor(value);
                                            break;
                                        case "ceil":
                                            value = Math.ceil(value);
                                            break;
                                        case "round":
                                            value = Math.round(value);
                                            break;
                                        case "number":
                                            value = numeral(value).format();
                                            break;
                                    }
                                }
                                let regex = new RegExp('{' + replaceKey.toLowerCase().replace('localizedata', '') + '}', "g");
                                result = result.replace(regex, value);
                            });
                        }
                    }

                    $element.html(result);
                };

                loadString(true);
            }
        }
    });

    module.directive("disableAnimate", function ($animate) {
        return function (scope, element) {
            $animate.enabled(element, false);
        };
    });

    module.controller('GameController', function ($rootScope, $scope, $timeout, $interval) {
        $rootScope.saveGameIdentifier = null;
        setupOptions($rootScope, () => {
            addFinanceWatches($rootScope);
            setupGlobalMethods($rootScope);
            addUiWatches($rootScope);


            // Register Wallhack
            if($rootScope.options.hasCompletedWelcome) {
                wallhack.registerProfile($rootScope.options.clientId, 'sc', $rootScope.options.email);
            }

            // Setup auto save
            $rootScope.options.autoSaveInterval = $rootScope.options.autoSaveInterval || 10000; // TODO: remove after playtest
            setInterval(function () {
                if ($rootScope.settings != null) {
                    let saveValue = JSON.stringify($rootScope.settings);
                    let filename = Helpers.GetSaveGameIdentifer($rootScope.settings.id);
                    Remote.app.saveFile(filename, saveValue);
                    Helpers.ConsoleInfo('Saving file: ' + filename);
                }
            }, $rootScope.options.autoSaveInterval);

            Modding._loadMods(module.compileProvider, () => {
                Helpers.LoadLanguage(Database.languages.find(x => x.key == $rootScope.options.language), () => {
                    loadMenuItems($rootScope);

                    $rootScope.setActiveView('menu');
                    $rootScope.$digest();

                    // Load last save game
                    if ($rootScope.options.lastSaveGame != null) {
                        Helpers.LoadGame($rootScope, $rootScope.options.lastSaveGame, (settings) => {
                            if (settings != null) {
                                $timeout(() => {
                                    if ($rootScope.options.developerMode) {
                                        $rootScope.setActiveView(null);
                                    }
                                    ToggleLoader(false);
                                }, 100);
                            } else {
                                ToggleLoader(false);
                            }

                            Modding._executeEvent('onLoadGame', settings);
                        });
                    } else {
                        ToggleLoader(false);
                    }
                });
                $rootScope.$watch('options.developerMode', activated => {
                    if (activated) {
                        this.developerMode = true;
                        (function () {
                            let a = document.createElement("script");
                            a.src = "libs/ng-stats.js";
                            a.onload = function () {
                                window.showAngularStats()
                            };
                            document.head.appendChild(a)
                        })();
                        if (!Remote.getCurrentWindow().isDevToolsOpened()) {
                            Remote.getCurrentWindow().toggleDevTools();
                        }
                    }
                });
            });
        });

        $interval(() => {
            if ($rootScope.settings != null) {
                wallhack.setProperties({
                    workstations: $rootScope.settings.office.workstations.length,
                    furniture: $rootScope.settings.office.items.length,
                    money: Math.round($rootScope.settings.balance),
                    tier: $rootScope.tierInfo.currentTier,
                    products: $rootScope.settings.products.length,
                    building: $rootScope.settings.office.buildingName,
                    version: $rootScope.BetaVersion,
                    steamEnabled: Remote.app.greenworks.initAPI()
                });
                Helpers.ConsoleInfo('Updated Wallhack properties')
            }
        }, 1000 * 60); // 1 minute

        $rootScope.confirm = function (title, message, callback) {
            $rootScope.Message.body = message;
            $rootScope.Message.callback = callback;
            $rootScope.Message.isConfirm = true;
            $rootScope.Message.visible = true;
        };

        $rootScope.resetConfirm = () => {
            $rootScope.Message = {visible: false, message: null, callback: null, isConfirm: false};
        };

        $rootScope.ContractStatuses = ContractStatuses;
        $rootScope.EmployeeTypeNames = EmployeeTypeNames;
        $rootScope.EmployeeTypes = EmployeeTypes;
        $rootScope.EmployeeLevels = EmployeeLevels;
        $rootScope.ContractTypes = ContractTypes;
        $rootScope.GetSkillByName = GetSkillByName;
        $rootScope.ComponentTypes = ComponentTypes;
        $rootScope.Helpers = Helpers;
        $rootScope.Math = Math;
        $rootScope.Priorities = Priorities;
        $rootScope.BetaVersion = `${Configuration.BETA_VERSION}.${Configuration.BETA_SUBVERSION}`;
        $rootScope.showMenu = false;
        $rootScope.Enums = Enums;
        $rootScope.numeral = numeral;
        $rootScope.Configuration = Configuration;
        $rootScope.menuItems = [];
        $rootScope.resetConfirm();

        $rootScope.$on(GameEvents.ProductChange, () => Game.Lifecycle._runEvents());
        $rootScope.$on(GameEvents.SpeedChange, () => {
            Game.Lifecycle._loadEmployeeStats();
            $rootScope.$broadcast(GameEvents.WorkstationChange);
        });

        $rootScope.$on(GameEvents.EmployeeChange, () => {
            Game.Lifecycle._loadEmployeeStats();
            $rootScope.$broadcast(GameEvents.WorkstationChange);
        });

        $rootScope.$on(GameEvents.WorkstationChange, () => {
            Game.Lifecycle._runEvents();
        });

        $rootScope.$on(GameEvents.ContractChange, () => {
            $rootScope.$broadcast(GameEvents.EmployeeChange);
            Modding.setMenuItemBadgeCount('contracts', $rootScope.settings.contracts.filter(x => !x.completed).length);
        });

        $rootScope.$watch('settings.candidates.length', value => {
            if (value == null) return;
            Modding.setMenuItemBadgeCount('employees', $rootScope.settings.candidates.length);
            $rootScope.$broadcast(GameEvents.CandidateChange);
        });

        $rootScope.$watch('options.activeAchievement', achievement => {
            if (achievement != null) {
                $timeout(() => {
                    $rootScope.options.activeAchievement = null;
                }, 10000);
            }
        });

        $rootScope.startIdleTimer = () => {
            if (Game._idleTimer == null && $rootScope.settings && !$rootScope.settings.paused) {
                Game._idleTimer = setTimeout(() => {
                    Game.Lifecycle.PauseTime(false, true);
                    Game._idleTimer = null;
                }, 1000 * 60); // 1 minute
            }
        };

        //Add click sound for all buttons
        $('body').on('mousedown', '.btn, [ng-click], .playClick,[onclick]', function () {
            PlaySound(Sounds.click);
        });

        this.onLoad = () => {
            $(window).resize(() => SetZoom());
            SetZoom();

            $('body').on('mousewheel', '.horizontal-scroll', function (event) {
                this.scrollLeft -= (-event.originalEvent.deltaY);
                event.preventDefault();
            });

            $(window).blur(() => {
                let $rootScope = GetRootScope();
                if (!$rootScope.options.allowRunInBackground) {
                    $rootScope.startIdleTimer();
                }
            });

            $(window).focus(() => {
                if (Game._idleTimer) {
                    clearTimeout(Game._idleTimer);
                    Game._idleTimer = null;
                }
                ;
            });
        };

        this.keyUp = function (e) {
            ShiftPressed = false;
            switch (e.keyCode) {
                case 65: // A
                    wasd.left = false;
                    break;
                case 83: // S
                    wasd.down = false;
                    break;
                case 68: // D
                    wasd.right = false;
                    break;
                case 87: // W
                    wasd.up = false;
                    break;
            }

            if (!wasd.left && !wasd.right && !wasd.up && !wasd.down) {
                clearInterval(wasdListener);
                wasdListener = null;
            }
        };

        this.keyDown = function (e) {
            if (wasdListener == null) {
                wasdListener = setInterval(function () {
                    if ($rootScope.settings != null) {
                        WasdController();
                    }
                }, 20);
            }

            if (e.shiftKey) {
                ShiftPressed = true;
            }

            if (document.activeElement.tagName != "INPUT"
                && document.activeElement.tagName != "TEXTAREA"
                && $rootScope.view != 'menu') {
                switch (e.keyCode) {
                    case 27: // esc
                        if ($rootScope.contractRequest != null) return;

                        if ($rootScope.Message.visible) {
                            $rootScope.resetConfirm();
                        } else {
                            if (!IsDialogOpen() && $rootScope.itemPreview == null && $rootScope.itemMove == null) {
                                $rootScope.setActiveView('menu');
                            } else {
                                $rootScope.closeAllUi();
                            }
                        }
                        return false;

                    case 65: // A
                        wasd.left = true;
                        break;
                    case 83: // S
                        wasd.down = true;
                        break;
                    case 68: // D
                        wasd.right = true;
                        break;
                    case 87: // W
                        wasd.up = true;
                        break;
                    case 46: // delete
                        if ($rootScope.itemPreview != null) {
                            $rootScope.itemPreview = null;
                            ClearHoveredCells();
                        }
                        if ($rootScope.itemMove != null) {
                            $rootScope.sellItem();
                        }
                        break;
                    case 32: // Space
                        Game.Lifecycle.PauseTime(true);
                        e.preventDefault();
                        break;
                    case 49: // 1
                        Game.Lifecycle.PauseTime(true);
                        break;
                    case 50: // 2
                        Game.Lifecycle.StartTime(1, true);
                        break;
                    case 51: // 3
                        Game.Lifecycle.StartTime(2, true);
                        break;
                    case 82: // R
                        if ($rootScope.itemPreview != null || $rootScope.itemMove != null) {
                            $rootScope.rotateSelection();
                        }
                        break;
                }
            }
        };

        $rootScope.closeAllUi = function () {
            if ($rootScope.settings == null) return;
            if ($rootScope.settings.contractReportId != null) {
                $rootScope.settings.contractReportId = null;
                Helpers.TakeCareOfResumingGame();
            } else if ($rootScope.settings.tierReport != null) {
                $rootScope.settings.tierReport = null;
                Helpers.TakeCareOfResumingGame();
            } else {
                $rootScope.setActiveView(null);
                $rootScope.selectedWorkstation = null;
                $rootScope.employeeType = null;
                $rootScope.itemPreview = null;

                HideMouseoverEvents();
                ClearHoveredCells();
            }
        };

        this.click = function (e) {
            let target = $(e.target);
            let isDialog = target.parents('.dialog').length != 0 || target.hasClass('dialog');
            let isClickEvent = target.parents('[ng-click]:not(body)').length != 0 || e.target.hasAttribute('ng-click');

            if (!isDialog && !isClickEvent) {
                $rootScope.closeAllUi();
            }
        };

        $rootScope.$watch('settings.xp', (newValue, oldValue) => {
            if (newValue == null) return;

            let newTier = Helpers.CalculateCompanyTier(newValue);
            let oldTier = Helpers.CalculateCompanyTier(oldValue);

            if (newValue != null) {
                $rootScope.companyTier = newTier;
            }

            $rootScope.tierInfo = {
                currentTier: newTier,
                currentXp: $rootScope.settings.xp,
                nextTier: newTier + 1,
                xpForCurrentTier: Helpers.GetXpByTier(newTier),
                settingsId: $rootScope.settings.id
            };

            $rootScope.tierInfo.xpForNextTier = Helpers.GetXpByTier($rootScope.tierInfo.nextTier) || $rootScope.tierInfo.xpForCurrentTier;

            if ($rootScope.tierInfo.xpForCurrentTier == $rootScope.tierInfo.xpForNextTier) {
                $rootScope.tierInfo.nextTier = $rootScope.tierInfo.currentTier;
            }

            if ($rootScope.tierInfo.xpForNextTier == null) {
                $rootScope.tierInfo.tierCompletion = 100;
            } else {
                $rootScope.tierInfo.tierCompletion = $rootScope.getPercentage(
                    $rootScope.settings.xp,
                    $rootScope.tierInfo.xpForNextTier,
                    $rootScope.tierInfo.xpForCurrentTier);
            }

            if (newTier > oldTier && $rootScope.tierInfo.settingsId == $rootScope.settings.id) {
                Game.Lifecycle.PauseTime(true, true);
                $rootScope.settings.tierReport = newTier;
                wallhack.sendEvent("reached_new_tier", `Tier ${ newTier }`);
                $rootScope.addNotification(Helpers.GetLocalized('you_reached_tier', {tier: newTier}), 4);
                PlaySound(Sounds.victory);
            }

            $rootScope.tierInfo.settingsId = $rootScope.settings.id;
        });

        $rootScope.$watchCollection('settings.inventory', () => $rootScope.$broadcast(GameEvents.InventoryChange));

        $rootScope.$watch('settings.office.buildingName', buildingName => {
            $rootScope.activeBuilding = Buildings.find(x => x.name == buildingName);
        });
    });

    module.filter('floor', function () {
        return function (input) {
            return Math.floor(input);
        };
    });

    module.directive('ngRightClick', function ($parse) {
        return function (scope, element, attrs) {
            let fn = $parse(attrs.ngRightClick);
            element.bind('contextmenu', function (event) {
                scope.$apply(function () {
                    event.preventDefault();
                    fn(scope, {$event: event});
                });
            });
        };
    });

    module.directive('component', function () {
        return {
            restrict: 'E',
            templateUrl: 'templates/_component.html',
            scope: {
                component: '=',
                stackAmount: '=',
                disablePopover: '=',
                popoverContent: '@',
                popoverHeader: '@',
                developmentProgress: '=',
                showInventoryAmount: '=',
                showPrice: '=',
                checked: '=',
                alwaysEnabled: '=',
            },
            controller: function ($rootScope, $scope) {
                let loadComponent = () => {
                    console.log('loadComponent');
                    if ($scope.component != null) {
                        $scope.disablePopover = $scope.disablePopover || false;
                        $scope.showPrice = $scope.showPrice || false;
                        $scope.showInventoryAmount = $scope.showInventoryAmount || false;

                        let hasCustomPopoverContent = $scope.popoverContent != null;
                        let locked = false;
                        let isTooLowLevel = false;

                        let employeeTypesForProductionTime = [
                            EmployeeTypeNames.LeadDeveloper,
                            EmployeeTypeNames.Developer,
                            EmployeeTypeNames.Designer,
                            EmployeeTypeNames.DevOps,
                            EmployeeTypeNames.Marketer
                        ];

                        let setLockState = () => {
                            // Check if module is too high for employee level

                            if ($scope.alwaysEnabled != true && $rootScope.selectedWorkstation != null && employeeTypesForProductionTime.includes($rootScope.selectedWorkstation.employee.employeeTypeName)) {
                                if (!Helpers.IsEmployeeLevelCorrect($scope.component.employeeLevel, $rootScope.selectedWorkstation.employee.level)) {
                                    locked = true;
                                    isTooLowLevel = true;
                                }
                            }

                            $scope.locked = locked;
                        };
                        setLockState();

                        if ($scope.popoverHeader == null) {
                            $scope.popoverHeader = Helpers.GetLocalized($scope.component.name);
                        }

                        let loadDefaultPopoverContent = () => {
                            $scope.popoverContent = '';
                            setLockState();

                            // Show level
                            $scope.popoverContent += `<div class="text-center dimmed">${Helpers.GetLocalized('level')}: <strong>${ Helpers.GetLocalized($scope.component.employeeLevel) }</strong></div><hr>`;

                            // Show dependencies
                            if ($scope.component.type != ComponentTypes.Component) {
                                $scope.popoverContent += Helpers.GetBaseComponentPopoverText($scope.component);
                            } else {
                                $scope.popoverContent += `<div class="text-center dimmed">${Helpers.GetLocalized('rawcomponent')}</div>`;
                            }

                            // Show compute units
                            if ($scope.component.computeUnit != null) {
                                $scope.popoverContent += `<div class="text-center">${ Helpers.GetLocalized('compute_units_amount', {amount: $scope.component.computeUnits}) }</div>`;
                            }

                            // Show production time
                            let produceHours = Helpers.CalculateComponentProductionHours($scope.component);
                            let productionSpeed = produceHours;


                            if ($rootScope.selectedWorkstation != null && employeeTypesForProductionTime.includes($rootScope.selectedWorkstation.employee.employeeTypeName)) {
                                let speed = ApplyBonuses($rootScope.selectedWorkstation, $rootScope.selectedWorkstation.employee.speed, $rootScope.officeBonus);
                                productionSpeed = 100 * produceHours / speed;
                                $scope.popoverContent += `<div class="text-center">${ Helpers.GetLocalized('prod_time_amount', {
                                    time: productionSpeed.toFixed(1),
                                    originaltime: produceHours
                                }) }</div>`;
                            }

                            // Show price
                            if ($scope.showPrice) {
                                $scope.popoverContent += "<hr>" + (locked
                                        ? `<div class="text-center">${ isTooLowLevel ? `<span class="color-red">${ Helpers.GetLocalized('requires_higher_employee_level') }</span>` : Helpers.GetLocalized('unlocked_at_tier', {tier: $scope.component.tier})}</div>`
                                        : `<div class="text-center text-bold">${ numeral(Helpers.GetResearchPrice($scope.component)).format(Configuration.CURRENCY_FORMAT) }</div>`);
                            }
                        };

                        if (!hasCustomPopoverContent) {
                            loadDefaultPopoverContent();
                        }

                        if ($scope.showInventoryAmount) {
                            let loadAmount = () => {
                                $scope.inventoryAmount = $rootScope.settings.inventory[$scope.component.name] || 0;

                                if (!hasCustomPopoverContent) {
                                    loadDefaultPopoverContent();
                                }
                            };
                            $scope.$on(GameEvents.InventoryChange, () => loadAmount());
                            $scope.$on(GameEvents.SelectedWorkstationChange, () => loadAmount());
                            loadAmount();
                        }

                        $scope.cancelClick = $event => {
                            if (locked || isTooLowLevel) {
                                $event.stopPropagation();
                            }
                        };
                    }
                };

                $scope.$watch('component', () => loadComponent());
            },
        }
    });

    module.directive('employeeBox', function () {
        return {
            restrict: 'E',
            templateUrl: 'templates/_employeeBox.html',
            controller: function ($rootScope, $scope, $parse, $attrs) {
                $scope.employee = $parse($attrs.ngEmployee)($scope);
                $scope.wer = Helpers.CalculateWer();
                $scope.mode = $attrs.ngMode;
            },
        }
    });

    module.directive('achievement', function () {
        return {
            restrict: 'E',
            templateUrl: 'templates/achievement.html',
            controller: function ($rootScope, $scope) {
            },
        }
    });

    function setupGlobalMethods($rootScope) {
        $rootScope.getPercentage = function (value, total, startValue) {
            if (startValue == null) startValue = 0;
            if (value >= total) return 100;

            return Math.floor((value - startValue) * 100 / (total - startValue));
        };

        $rootScope.setActiveView = function (view, tab) {
            $rootScope.selectedWorkstation = null;

            if ($rootScope.view == view) {
                $rootScope.view = null;
                $rootScope.tab = null;
            } else {
                $rootScope.view = view;
                $rootScope.tab = tab;
            }

            if (view == 'menu' && $rootScope.settings != null) {
                Game.Lifecycle.PauseTime(true, true);
            }
        };

        $rootScope.getTaskPercentage = () => {
            if ($rootScope.selectedWorkstation.employee.task == null) return 0;
            return Math.floor($rootScope.selectedWorkstation.employee.task.completedMinutes * 100 / $rootScope.selectedWorkstation.employee.task.totalMinutes);
        };

        $rootScope.showMessage = function (title, message, callback) {
            $rootScope.Message.body = message;
            $rootScope.Message.callback = callback;
            $rootScope.Message.isConfirm = false;
            $rootScope.Message.visible = true;
        };

        $rootScope.addNotification = (message, hoursUntilClose, reference, type, silent, target) => {
            PushAsStack($rootScope.settings.notifications,
                {
                    id: chance.guid(),
                    reference: reference,
                    day: GetDateDiffInDays($rootScope.settings.date),
                    message: message,
                    hoursUntilClose: hoursUntilClose,
                    closed: false,
                    type: type || Enums.NotificationTypes.Info,
                    target: target
                },20);

            if (!$rootScope.$$phase) {
                $rootScope.$digest();
            }

            if (silent != true)
                PlaySound(Sounds.messagePingX2);
        };

        // Use either reference or notificationId to identify
        $rootScope.removeNotification = (reference, notificationId) => {
            _.remove($rootScope.settings.notifications, x => x.id == notificationId || x.reference == reference);
        };

        $rootScope.sendMail = (sender, subject, message) => {
            let id = chance.guid();
            $rootScope.settings.mails.push(
                {
                    id: id,
                    read: false,
                    subject: subject,
                    message: message,
                    sender: sender,
                    day: GetDateDiffInDays($rootScope.settings.date),
                    time: $rootScope.settings.date.getTime()
                });

            PlaySound(Sounds.gameNotification80);
            $rootScope.addNotification(Helpers.GetLocalized("you_received_mail"), 4, id, true, null, {view: 'inbox'});
        };

        $rootScope.addTransaction = (label, amount) => {
            PushAsStack($rootScope.settings.transactions, {
                id: chance.guid(),
                day: GetDateDiffInDays($rootScope.settings.date),
                amount: amount,
                label: label,
                balance: $rootScope.settings.balance
            }, 30);
        };

        $rootScope.safeBuy = function (job, totalPrice, transactionLabel) {
            if (totalPrice > $rootScope.settings.balance) {
                let balanceValue = $('#topbar .balance');
                balanceValue.addClass('warn');
                PlaySound(Sounds.click);
                setTimeout(() => {
                    balanceValue.removeClass('warn');
                }, 800);
                PlaySound(Sounds.softFail);
            } else {
                job();
                PlaySound(Sounds.money);
                $rootScope.settings.balance -= totalPrice;
                $rootScope.addTransaction(transactionLabel, -totalPrice);
            }
        };
    }

    function addUiWatches($rootScope) {
        $rootScope.$watch('view', function (newView, oldValue) {
            if (newView == 'finance') {
                $rootScope.updateFinanceData();
            }
        });

        $rootScope.$watchGroup(['options.masterVolume', 'options.musicVolume'], function (newView) {
            PlayLoop(Sounds.music);
        });

        $rootScope.$on(GameEvents.GridChange, () => {
            $rootScope.officeBonus = Helpers.CalculateOfficeBonus();
        });
    }

    function loadMenuItems($rootScope) {
        $rootScope.menuItems = [
            {
                name: 'purchase',
                tooltip: Helpers.GetLocalized('purchase_item'),
                tooltipPosition: 'top',
                faIcon: 'fa-shopping-basket',
                badgeCount: 0,
            },
            {
                name: 'finance',
                tooltip: Helpers.GetLocalized('finance'),
                tooltipPosition: 'top',
                faIcon: 'fa-money',
                badgeCount: '',
            },
            {
                name: 'inventory',
                tooltip: Helpers.GetLocalized('inventory'),
                tooltipPosition: 'top',
                faIcon: 'fa-th',
                badgeCount: 0,
            },
            {
                name: 'contracts',
                tooltip: Helpers.GetLocalized('contracts'),
                tooltipPosition: 'top',
                faIcon: 'fa-wpforms',
                badgeCount: 0,
            },
            {
                name: 'employees',
                tooltip: Helpers.GetLocalized('employees'),
                tooltipPosition: 'top',
                faIcon: 'fa-users',
                badgeCount: 0,
            },
            {
                name: 'company',
                tooltip: Helpers.GetLocalized('company_profile'),
                tooltipPosition: 'top',
                faIcon: 'fa-building-o',
                badgeCount: 0,
            },
            {
                name: 'menu',
                tooltip: Helpers.GetLocalized('main_menu'),
                tooltipPosition: 'left',
                faIcon: 'fa-wrench',
                badgeCount: 0,
            },
        ];
    }

    function addFinanceWatches($rootScope) {
        $rootScope.updateFinanceData = function () {
            if ($rootScope.settings == null || !$rootScope.settings.started) return false;

            // Expenses
            let totalSalary = 0;
            let monthlyIncome = 0;

            // Salaries
            Helpers.GetAllEmployees(true).forEach(employee => {
                totalSalary += employee.salary;
            });

            // Loans
            let loans = _.sumBy($rootScope.settings.loans.filter(x => x.active), 'dailyPayment');

            // Hosting expenses
            let hostingExpenses = _.sum(
                $rootScope.settings.products.map(product => Helpers.CalculateHostingExpenses(product)));

            $rootScope.financeData = {
                expenses: {
                    officeRent: $rootScope.activeBuilding.rent,
                    totalSalary: totalSalary,
                    loans: loans,
                    hostingExpenses: hostingExpenses,
                    benefits: _.sumBy(
                        $rootScope.settings.activatedBenefits.map(benefitId => Database.benefits.find(x => x.id == benefitId)), x => Helpers.CalculateBenefitCost(x).monthly)
                }
            };

            $rootScope.financeData.expenses.total =
                $rootScope.financeData.expenses.officeRent +
                $rootScope.financeData.expenses.totalSalary +
                $rootScope.financeData.expenses.loans +
                $rootScope.financeData.expenses.hostingExpenses +
                $rootScope.financeData.expenses.benefits;

            $rootScope.financeData.expenses.perHour = $rootScope.financeData.expenses.total / 30 / 24;
            $rootScope.financeData.expenses.perDay = $rootScope.financeData.expenses.perHour * 24;

            // Income
            let currentDay = GetDateDiffInDays($rootScope.settings.date);

            let last30daysContracts = _.sum($rootScope.settings.contracts.filter(x => x.status == 'Won' && x.completed && x.completionDay >= currentDay - 30).map(x => x.price));
            let last30daysProductIncome = _.sum($rootScope.settings.products.map(x => {
                return _.sum(x.stats.filter(s => s.day >= currentDay - 30).map(s => s.income))
            }));

            monthlyIncome += last30daysContracts;
            monthlyIncome += last30daysProductIncome;

            $rootScope.financeData.income = {
                totalIncome: monthlyIncome,
            };

            let profit = $rootScope.financeData.income.totalIncome - $rootScope.financeData.expenses.total;


            $rootScope.financeData.profit = {
                perMonth: profit,
                perHour: profit / 30 / 24,
                perDay: profit / 30
            }
        };
    }

    function setupOptions($rootScope, cb) {
        // Load from disk
        let options = null;
        let optionsIdentifier = Helpers.GetOptionsIdentifer();

        PlayLoop(Sounds.music);

        $rootScope.saveOptions = () => {
            Remote.app.saveFile(optionsIdentifier, JSON.stringify($rootScope.options));

            PlayLoop(Sounds.music);
            Helpers.ConsoleInfo('Options saved');
        };

        Remote.app.loadFile(optionsIdentifier, data => {
            options = JSON.parse(data);

            if (options == null) {
                options = _.clone(Database.options, true);
                options.clientId = chance.guid();
            }

            if (!options.hasCompletedWelcome && options.language == null) {
                let locale = navigator.language;

                switch (locale.toLowerCase().substring(0, 2)) {
                    case "fr":
                        options.language = "fr";
                        break;
                    case "de":
                        options.language = "de";
                        break;
                    case "es":
                        options.language = "es";
                        break;
                    default:
                        options.language = "en";
                        break;
                }
            }

            Helpers.PrepareOptionsCompatibility(options);

            $rootScope.options = options;
            $rootScope.saveOptions();

            // Initialize startup options
            SetFullScreen($rootScope.options.fullScreen);

            cb();
        });
    }

})();

function WasdController() {
    let office = $('office');
    let amount = 10;

    if (wasd.up) {
        office.scrollTop(office.scrollTop() - amount);
    }

    if (wasd.left) {
        office.scrollLeft(office.scrollLeft() - amount);
    }

    if (wasd.right) {
        office.scrollLeft(office.scrollLeft() + amount);
    }

    if (wasd.down) {
        office.scrollTop(office.scrollTop() + amount);
    }
}